#include "STC8H.h"
#include <intrins.h>


sbit TM1650_SDA = P3^6;  
sbit TM1650_SCL = P3^7;  



unsigned char code SEG_TABLE[] = {
    0x3F, 0x06, 0x5B, 0x4F, 0x66, 
    0x6D, 0x7D, 0x07, 0x7F, 0x6F,
    0x77, 0x7C, 0x39, 0x5E, 0x79,
  	0x71, 0x7F
};


void I2C_Start(void) {
    TM1650_SDA = 1;  
    TM1650_SCL = 1;  
    _nop_();         
    TM1650_SDA = 0;  
    

}


void I2C_Stop(void) {
    TM1650_SDA = 0;  
    TM1650_SCL = 1;  
    _nop_();
    TM1650_SDA = 1;  
    

}


void I2C_SendByte(unsigned char dat) {
    unsigned char i;
    for(i = 0; i < 8; i++) {  
        TM1650_SDA = (dat >> 7) & 0x01;  
        dat <<= 1;                       
        TM1650_SCL = 1;
        _nop_();
        TM1650_SCL = 0;                 
        _nop_();
    }
  
    TM1650_SDA = 1;
    _nop_();
    TM1650_SCL = 1;
    _nop_();
    TM1650_SCL = 0;
}


void TM1650_Init(void) {
    I2C_Start();
    I2C_SendByte(0x48);  
    I2C_SendByte(0x85);  
    I2C_Stop();
}


void TM1650_Display(unsigned char d1, unsigned char d2, unsigned char d3, unsigned char d4) {
    I2C_Start();
    I2C_SendByte(0x48);  
    I2C_SendByte(0x60);  
    I2C_SendByte(SEG_TABLE[d1]);  
    I2C_SendByte(SEG_TABLE[d2]);  
    I2C_SendByte(SEG_TABLE[d3]);  
    I2C_SendByte(SEG_TABLE[d4]);  
    I2C_Stop();
}


void main(void) {
    TM1650_Init();  
    
    TM1650_Display(8,8,8,8);  
    
    while(1) {
        
    }
}